#ifndef __CScrollBar__
#define __CScrollBar__

#include "CSlider.hpp"
#include "CScrollBarImages.hpp"
#include "../Listeners/IScrollListener.hpp"

//	===========================================================================

using Exponent::GUI::Controls::CSlider;
using Exponent::GUI::Controls::CScrollBarImages;
using Exponent::GUI::Listeners::IScrollListener;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CScrollBar CScrollBar.hpp
			 * @brief Scroll bar
			 *
			 * @date 19/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 * @version 1.0.1 Update to suit new CScrollPanel
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CScrollBar.hpp,v 1.5 2007/02/08 21:07:54 paul Exp $
			 */
			class CScrollBar : public CSlider, public IActionListener
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction 
				 * @param root The root control
				 * @param uniqueId The uniqueId
				 * @param area The area of the control
				 * @param virtualArea The virtual area to cover
				 * @param scrollListener The scrolling listener
				 */
				CScrollBar(IControlRoot *root, const long uniqueId, const CRect &area, const CRect &virtualArea, IScrollListener *scrollListener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CScrollBar();

//	===========================================================================

				/**
				 * Draw the controls
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

				/**
				 * Set the virtual area
				 * @param virtualArea The virtual area
				 */
				void setVirtualArea(const CRect &virtualArea);

				/**
				 * Register scroll listener
				 * @param listener The scrolling listener
				 */
				virtual void registerScrollListener(IScrollListener *listener);
				
				/**
				 * Handle events from the slider
				 * @param event The scrolling event
				 */
				virtual void handleActionEvent(const CActionEvent &event);

//	===========================================================================

				/**
				 * Set the scroll bar images
				 * @param normal Normal graphics
				 * @param mouseOver The mouse over graphics
				 * @param mouseDown The mouse down graphics
				 */
				void setScrollBarImages(CScrollBarImages *normal, CScrollBarImages *mouseOver, CScrollBarImages *mouseDown);

//	===========================================================================

			protected:

//	===========================================================================

				IScrollListener *m_scrollListener;			/**< The scroll message listener */

				CRect m_virtualArea;						/**< The virtual area */
				double m_areaRatio;							/**< Ratio of true area to virtual area */

				CScrollBarImages *m_normalImages;			/**< Normal images */
				CScrollBarImages *m_mouseOverImage;			/**< Over images */
				CScrollBarImages *m_mouseDownImages;		/**< Down images */
			};
		}
	}
}
#endif	// End of CScrollBar.hpp